/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.data.recipe;

import com.simibubi.create.api.data.recipe.ProcessingRecipeGen;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeProvider;
import org.forsteri.ratatouille.data.recipe.BakingRecipeGen;
import org.forsteri.ratatouille.data.recipe.CompostingRecipeGen;
import org.forsteri.ratatouille.data.recipe.DemoldingRecipeGen;
import org.forsteri.ratatouille.data.recipe.FreezingRecipeGen;
import org.forsteri.ratatouille.data.recipe.SqueezingRecipeGen;
import org.forsteri.ratatouille.data.recipe.ThreshingRecipeGen;
import org.forsteri.ratatouille.data.recipe.create.RatatouilleCompactingRecipeGen;
import org.forsteri.ratatouille.data.recipe.create.RatatouilleCuttingRecipeGen;
import org.forsteri.ratatouille.data.recipe.create.RatatouilleEmptyingRecipeGen;
import org.forsteri.ratatouille.data.recipe.create.RatatouilleFillingRecipeGen;
import org.forsteri.ratatouille.data.recipe.create.RatatouilleMillingRecipeGen;
import org.forsteri.ratatouille.data.recipe.create.RatatouilleMixingRecipeGen;
import org.jetbrains.annotations.NotNull;

public final class RatatouilleRecipeProvider
extends RecipeProvider {
    static final List<ProcessingRecipeGen<?, ?, ?>> GENERATORS = new ArrayList();
    static final int BUCKET = 1000;
    static final int BOTTLE = 250;

    public RatatouilleRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    public static void registerAllProcessing(DataGenerator gen, PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new ThreshingRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new SqueezingRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new DemoldingRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new FreezingRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new CompostingRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new BakingRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new RatatouilleCompactingRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new RatatouilleCuttingRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new RatatouilleEmptyingRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new RatatouilleFillingRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new RatatouilleMillingRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new RatatouilleMixingRecipeGen(output, registries));
        gen.addProvider(true, new DataProvider(){

            @NotNull
            public CompletableFuture<?> run(CachedOutput dc) {
                return CompletableFuture.allOf((CompletableFuture[])GENERATORS.stream().map(gen -> gen.run(dc)).toArray(CompletableFuture[]::new));
            }

            @NotNull
            public String getName() {
                return "Create: Ratatouille's Processing Recipes";
            }
        });
    }
}

